/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ig extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "Nauru";
        final String metaValue_TV = "Tuvalu";
        final String metaValue_ban = "Balinese";
        final String metaValue_bug = "Buginese";
        final String metaValue_ccp = "Chakma";
        final String metaValue_chr = "Cherokee";
        final String metaValue_jv = "Javanese";
        final String metaValue_ja = "Japanese";
        final String metaValue_km = "Khmer";
        final String metaValue_kn = "Kannada";
        final String metaValue_ko = "Korean";
        final String metaValue_lo = "Lao";
        final String metaValue_la = "Latin";
        final String metaValue_mak = "Makasar";
        final String metaValue_men = "Mende";
        final String metaValue_ml = "Malayalam";
        final String metaValue_nqo = "N\u2019Ko";
        final String metaValue_osa = "Osage";
        final String metaValue_si = "Sinhala";
        final String metaValue_ta = "Tamil";
        final String metaValue_te = "Telugu";
        final String metaValue_bo = "Tibetan";
        final String metaValue_type_ca_islamic = "Kalenda Hijri";
        final Object[][] data = new Object[][] {
            { "001", "Uwa" },
            { "002", "Afrika" },
            { "003", "Mpaghara Ugwu Amer\u1ecbka" },
            { "005", "Mpaghara Mgbada Ugwu America" },
            { "009", "Oceania" },
            { "011", "Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Afr\u1ecbka" },
            { "013", "Etiti America" },
            { "014", "Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Afr\u1ecbka" },
            { "015", "Mpaghara Ugwu Afr\u1ecbka" },
            { "017", "Etiti Afr\u1ecbka" },
            { "018", "Mpaghara Mgbada Ugwu Afr\u1ecbka" },
            { "019", "Amer\u1ecbka" },
            { "021", "Mpaghara Ugwu America" },
            { "029", "Caribbean" },
            { "030", "Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Asia" },
            { "034", "Mpaghara Mgbada Ugwu Asia" },
            { "035", "Mpaghara Mgbada Ugwu Asia d\u1ecb na \u1eccw\u1ee5wa Anyanw\u1ee5" },
            { "039", "Mpaghara Mgbada Ugwu Europe" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "057", "Mpaghara Micronesian" },
            { "061", "Polynesia" },
            { "142", "Asia" },
            { "143", "Etiti Asia" },
            { "145", "Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Asia" },
            { "150", "Europe" },
            { "151", "Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Europe" },
            { "154", "Mpaghara Ugwu Europe" },
            { "155", "Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Europe" },
            { "202", "Sub-Saharan Afr\u1ecbka" },
            { "419", "Latin America" },
            { "AC", "Ascension Island" },
            { "AD", "Andorra" },
            { "AE", "United Arab Emirates" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua na Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antarctica" },
            { "AR", "Argentina" },
            { "AS", "American Samoa" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "\u00c5land Islands" },
            { "AZ", "Azerbaijan" },
            { "BA", "Bosnia & Herzegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgium" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "St. Barth\u00e9lemy" },
            { "BM", "Bemuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Caribbean Netherlands" },
            { "BR", "Brazil" },
            { "BS", "Bahamas" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet Island" },
            { "BW", "Botswana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "CA", "Canada" },
            { "CC", "Agwaetiti Cocos (Keeling)" },
            { "CD", "Congo - Kinshasa" },
            { "CF", "Central African Republik" },
            { "CG", "Congo" },
            { "CH", "Switzerland" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Agwaetiti Cook" },
            { "CL", "Chile" },
            { "CM", "Cameroon" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "CP", "Agwaetiti Clipperton" },
            { "CQ", "Sark" },
            { "CR", "Kosta Rika" },
            { "CU", "Cuba" },
            { "CV", "Cape Verde" },
            { "CW", "Kurakao" },
            { "CX", "Agwaetiti Christmas" },
            { "CY", "Cyprus" },
            { "CZ", "Czechia" },
            { "DE", "Germany" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Denmark" },
            { "DM", "Dominica" },
            { "DO", "Dominican Republik" },
            { "DZ", "Algeria" },
            { "EA", "Ceuta & Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estonia" },
            { "EG", "Egypt" },
            { "EH", "\u1eccd\u1ecbda Anyanw\u1ee5 Sahara" },
            { "ER", "Eritrea" },
            { "ES", "Spain" },
            { "ET", "Ethiopia" },
            { "EU", "Otu nzuk\u1ecd mba Europe" },
            { "EZ", "Gburugburu Euro" },
            { "FI", "Finland" },
            { "FJ", "Fiji" },
            { "FK", "Falkland Islands" },
            { "FM", "Micronesia" },
            { "FO", "Faroe Islands" },
            { "FR", "France" },
            { "GA", "Gabon" },
            { "GB", "United Kingdom" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "French Guiana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Greenland" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Equatorial Guinea" },
            { "GR", "Greece" },
            { "GS", "South Georgia & South Sandwich Islands" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hong Kong SAR China" },
            { "HM", "Agwaetiti Heard na Agwaetiti McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croatia" },
            { "HT", "Haiti" },
            { "HU", "Hungary" },
            { "IC", "Canary Islands" },
            { "ID", "Indonesia" },
            { "IE", "Ireland" },
            { "IL", "Israel" },
            { "IM", "Isle of Man" },
            { "IN", "India" },
            { "IO", "British Indian Ocean Territory" },
            { "IQ", "Iraq" },
            { "IR", "Iran" },
            { "IS", "Iceland" },
            { "IT", "Italy" },
            { "JE", "Jersey" },
            { "JM", "Jamaika" },
            { "JO", "Jordan" },
            { "JP", "Japan" },
            { "KE", "Kenya" },
            { "KG", "Kyrgyzstan" },
            { "KH", "Cambodia" },
            { "KI", "Kiribati" },
            { "KM", "Comoros" },
            { "KN", "St. Kitts & Nevis" },
            { "KP", "North Korea" },
            { "KR", "South Korea" },
            { "KW", "Kuwait" },
            { "KY", "Cayman Islands" },
            { "KZ", "Kazakhstan" },
            { "LA", "Laos" },
            { "LB", "Lebanon" },
            { "LC", "St. Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lithuania" },
            { "LU", "Luxembourg" },
            { "LV", "Latvia" },
            { "LY", "Libia" },
            { "MA", "Morocco" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "St. Martin" },
            { "MG", "Madagascar" },
            { "MH", "Agwaetiti Marshall" },
            { "MK", "North Macedonia" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongolia" },
            { "MO", "Macao SAR China" },
            { "MP", "Agwaetiti Northern Mariana" },
            { "MQ", "Martinique" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Maldivesa" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambique" },
            { "NA", "Namibia" },
            { "NC", "New Caledonia" },
            { "NE", "Niger" },
            { "NF", "Agwaetiti Norfolk" },
            { "NG", "Na\u1ecbj\u1ecbr\u1ecba" },
            { "NI", "Nicaragua" },
            { "NL", "Netherlands" },
            { "NO", "Norway" },
            { "NP", "Nepal" },
            { "NR", metaValue_NR },
            { "NU", "Niue" },
            { "NZ", "New Zealand" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "French Polynesia" },
            { "PG", "Papua New Guinea" },
            { "PH", "Philippines" },
            { "PK", "Pakistan" },
            { "PL", "Poland" },
            { "PM", "St. Pierre & Miquelon" },
            { "PN", "Agwaetiti Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Mpaghara nd\u1ecb Palestine" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "Outlying Oceania" },
            { "RE", "R\u00e9union" },
            { "RO", "Romania" },
            { "RS", "Serbia" },
            { "RU", "Russia" },
            { "RW", "Rwanda" },
            { "SA", "Saudi Arabia" },
            { "SB", "Agwaetiti Solomon" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "SE", "Sweden" },
            { "SG", "Singapore" },
            { "SH", "St. Helena" },
            { "SI", "Slovenia" },
            { "SJ", "Svalbard & Jan Mayen" },
            { "SK", "Slovakia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Suriname" },
            { "SS", "South Sudan" },
            { "ST", "S\u00e3o Tom\u00e9 & Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syria" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks & Caicos Islands" },
            { "TD", "Chad" },
            { "TF", "\u1ee4m\u1ee5 ngalaba Frenchi Southern" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tajikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "TR", "T\u00fcrkiye" },
            { "TT", "Trinidad na Tobago" },
            { "TV", metaValue_TV },
            { "TW", "Taiwan" },
            { "TZ", "Tanzania" },
            { "UA", "Ukraine" },
            { "UG", "Uganda" },
            { "UM", "Obere Agwaetiti D\u1ecb Na Mp\u1ee5ga U.S" },
            { "UN", "Mba \u1ee4wa Jik\u1ecdr\u1ecd \u1eccn\u1ee5" },
            { "US", "United States" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekistan" },
            { "VA", "Vatican City" },
            { "VC", "St. Vincent & Grenadines" },
            { "VE", "Venezuela" },
            { "VG", "British Virgin Islands" },
            { "VI", "U.S. Virgin Islands" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis & Futuna" },
            { "WS", "Samoa" },
            { "XA", "Pseudo-Accents" },
            { "XB", "Pseudo-Bidi" },
            { "XK", "Kosovo" },
            { "YE", "Yemen" },
            { "YT", "Mayotte" },
            { "ZA", "South Africa" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Mpaghara A na-amagh\u1ecb" },
            { "aa", "Afar" },
            { "ab", "Abkaziani" },
            { "af", "Afrikaans" },
            { "ak", "Akan" },
            { "am", "Amariik\u1ecb" },
            { "an", "Aragonis\u1ecb" },
            { "ar", "Arabiik\u1ecb" },
            { "as", "Asamis\u1ecb" },
            { "av", "Avar\u1ecbk" },
            { "ay", "Aymara" },
            { "az", "Azerbaijani" },
            { "ba", "Bashkir" },
            { "be", "Belarusian" },
            { "bg", "Bulgarian" },
            { "bi", "Bislama" },
            { "bm", "Bambara" },
            { "bn", "Bangla" },
            { "bo", metaValue_bo },
            { "br", "Breton" },
            { "bs", "Bosnian" },
            { "ca", "Catalan" },
            { "ce", "Chechen" },
            { "ch", "Chamorro" },
            { "co", "Corsican" },
            { "cs", "Czech" },
            { "cu", "Church slavic" },
            { "cv", "Chuvash" },
            { "cy", "Welsh" },
            { "da", "Danish" },
            { "de", "German" },
            { "dv", "Divehi" },
            { "dz", "D\u1ecdzng\u1ecdka" },
            { "ee", "Ewe" },
            { "el", "Grik" },
            { "en", "Bekee" },
            { "eo", "Esperanto" },
            { "es", "Spanish" },
            { "et", "Estonian" },
            { "eu", "Basque" },
            { "fa", "As\u1ee5s\u1ee5 Persia" },
            { "ff", "Fula" },
            { "fi", "Finnish" },
            { "fj", "Fijan\u1ecb" },
            { "fo", "Faroese" },
            { "fr", "French" },
            { "fy", "\u1eccd\u1ecbda anyanw\u1ee5 Frisian" },
            { "ga", "Irish" },
            { "gd", "As\u1ee5s\u1ee5 Scottish Gaelic" },
            { "gl", "Galician" },
            { "gn", "Guarani" },
            { "gu", "Gujarati" },
            { "gv", "Mans\u1ecb" },
            { "ha", "Hausa" },
            { "he", "Hebrew" },
            { "hi", "Hindi" },
            { "hr", "Croatian" },
            { "ht", "Ha\u1ecbt\u1ecban nd\u1ecb Cer\u1ecdle" },
            { "hu", "Hungarian" },
            { "hy", "Armenian\u1ecb" },
            { "hz", "Herero" },
            { "ia", "Interlingua" },
            { "id", "Indonesian" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", "Sichuan Yi" },
            { "io", "Ido" },
            { "is", "Icelandic" },
            { "it", "Italian" },
            { "iu", "Inuktitut" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", "Georgian" },
            { "ki", "Kikuyu" },
            { "kj", "Kuanyama" },
            { "kk", "Kazakh" },
            { "kl", "Kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "Kanuri" },
            { "ks", "Kashmiri" },
            { "ku", "Kurdish" },
            { "kv", "Komi" },
            { "kw", "Cornish" },
            { "ky", "Kyrgyz" },
            { "la", metaValue_la },
            { "lb", "Luxembourgish" },
            { "lg", "Ganda" },
            { "li", "Limburgish" },
            { "ln", "Lingala" },
            { "lo", metaValue_lo },
            { "lt", "Lithuanian" },
            { "lu", "Luba-Katanga" },
            { "lv", "Latvian" },
            { "mg", "Malagasy" },
            { "mh", "Marshallese" },
            { "mi", "M\u0101ori" },
            { "mk", "Macedonian" },
            { "ml", metaValue_ml },
            { "mn", "M\u1ecdngol\u1ecban" },
            { "mr", "As\u1ee5s\u1ee5 Marathi" },
            { "ms", "Malay" },
            { "mt", "As\u1ee5s\u1ee5 Malta" },
            { "my", "Burmese" },
            { "na", metaValue_NR },
            { "nb", "Norwegian Bokm\u00e5l" },
            { "nd", "North Ndebele" },
            { "ne", "Nepali" },
            { "ng", "Ndonga" },
            { "nl", "Dutch" },
            { "nn", "Norwegian Nynorsk" },
            { "no", "Norwegian" },
            { "nr", "South Ndebele" },
            { "nv", "Navajo" },
            { "ny", "Nyanja" },
            { "oc", "As\u1ee5s\u1ee5 Os\u1ecbtan" },
            { "om", "Oromo" },
            { "or", "\u1eccd\u1ecba" },
            { "os", "Ossetic" },
            { "pa", "Punjabi" },
            { "pl", "As\u1ee5s\u1ee5 Polish" },
            { "ps", "Pash\u1ecd" },
            { "pt", "P\u1ecdrt\u1ee5g\u1ee5ese" },
            { "qu", "As\u1ee5s\u1ee5 Quechua" },
            { "rm", "As\u1ee5s\u1ee5 Romansh" },
            { "rn", "Rundi" },
            { "ro", "As\u1ee5s\u1ee5 Romanian" },
            { "ru", "As\u1ee5s\u1ee5 Russia" },
            { "rw", "Kinyarwanda" },
            { "sa", "As\u1ee5s\u1ee5 Sanskrit" },
            { "sc", "As\u1ee5s\u1ee5 Sardini" },
            { "sd", "As\u1ee5s\u1ee5 Sindhi" },
            { "se", "Northern Sami" },
            { "sg", "Sango" },
            { "si", metaValue_si },
            { "sk", "As\u1ee5s\u1ee5 Slovak" },
            { "sl", "As\u1ee5s\u1ee5 Slovenia" },
            { "sm", "Samoan" },
            { "sn", "Shona" },
            { "so", "Somali" },
            { "sq", "As\u1ee5s\u1ee5 Albania" },
            { "sr", "As\u1ee5s\u1ee5 Serbia" },
            { "ss", "Swati" },
            { "st", "Southern Sotho" },
            { "su", "As\u1ee5s\u1ee5 Sundan" },
            { "sv", "S\u1ee5widiishi" },
            { "sw", "As\u1ee5s\u1ee5 Swahili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "Tajik" },
            { "th", "Thai" },
            { "ti", "Tigrinya" },
            { "tk", "Turkmen" },
            { "tn", "Tswana" },
            { "to", "Tongan" },
            { "tr", "Turkish" },
            { "ts", "Tsonga" },
            { "tt", "As\u1ee5s\u1ee5 Tatar" },
            { "ty", "Tahitian" },
            { "ug", "Uyghur" },
            { "uk", "As\u1ee5s\u1ee5 Ukrain" },
            { "ur", "Urdu" },
            { "uz", "Uzbek" },
            { "ve", "Venda" },
            { "vi", "Vietnamese" },
            { "vo", "Volap\u00fck" },
            { "wa", "Walloon" },
            { "wo", "Wolof" },
            { "xh", "Xhosa" },
            { "yi", "Yiddish" },
            { "yo", "Yoruba" },
            { "za", "Zhuang" },
            { "zh", "Cha\u1ecbniiz" },
            { "zu", "Zulu" },
            { "ace", "Achinisi" },
            { "ada", "Adangme" },
            { "ady", "Adigi" },
            { "agq", "Aghem" },
            { "ain", "Ainu" },
            { "ale", "Aleut" },
            { "alt", "Southern Altai" },
            { "ann", "Obolo" },
            { "anp", "Angika" },
            { "apc", "apcc" },
            { "arn", "Mapuche" },
            { "arp", "Arapaho" },
            { "ars", "Najdi Arabik\u1ecb" },
            { "asa", "As\u1ee5" },
            { "ast", "Asturian\u1ecb" },
            { "atj", "Atikamekw" },
            { "awa", "Awadhi" },
            { "bal", "Baluchi" },
            { "ban", metaValue_ban },
            { "bas", "Basa\u00e0" },
            { "bem", "Bemb\u00e0" },
            { "bew", "Betawi" },
            { "bez", "Bena" },
            { "bgc", "Haryanvi" },
            { "bgn", "Western Balochi" },
            { "bho", "Bojpuri" },
            { "bin", "Bini" },
            { "bla", "Siksik\u00e0" },
            { "blo", "Anii" },
            { "blt", "Tai Dam" },
            { "brx", "Bodo" },
            { "bss", "Akoose" },
            { "bug", metaValue_bug },
            { "byn", "Blin" },
            { "cad", "Caddo" },
            { "cay", "Cayuga" },
            { "cch", "Atsam" },
            { "ccp", metaValue_ccp },
            { "ceb", "Cebuano" },
            { "cgg", "Chiga" },
            { "chk", "Chuukese" },
            { "chm", "Mari" },
            { "cho", "Choctaw" },
            { "chp", "Chipewyan" },
            { "chr", metaValue_chr },
            { "chy", "Cheyene" },
            { "cic", "Chickasaw" },
            { "ckb", "Central Kurdish" },
            { "clc", "Chilcotin" },
            { "crg", "Michif" },
            { "crj", "Southern East Cree" },
            { "crk", "Plains Cree" },
            { "crl", "Northern East Cree" },
            { "crm", "Moose Cree" },
            { "crr", "Carolina Algonquian" },
            { "csw", "As\u1ee5s\u1ee5 Swampy Kree" },
            { "dak", "Dakota" },
            { "dar", "Dargwa" },
            { "dav", "Taita" },
            { "dgr", "Dogrib" },
            { "dje", "Zarma" },
            { "doi", "Dogri" },
            { "dsb", "Lower Sorbian" },
            { "dua", "Duala" },
            { "dyo", "Jola-Fonyi" },
            { "dzg", "Dazaga" },
            { "ebu", "Embu" },
            { "efi", "Efik" },
            { "eka", "Ekajuk" },
            { "ewo", "Ewondo" },
            { "fil", "Filipino" },
            { "fon", "Fon" },
            { "frc", "Cajun French" },
            { "frr", "Northern Frisian" },
            { "fur", "Friulian" },
            { "gaa", "Ga" },
            { "gez", "Geez" },
            { "gil", "Gilbertese" },
            { "gor", "Gorontalo" },
            { "gsw", "German Swiss" },
            { "guz", "Gusii" },
            { "gwi", "Gwich\u02bcin" },
            { "hai", "Haida" },
            { "haw", "Hawa\u1ecbl\u1ecban" },
            { "hax", "Southern Haida" },
            { "hil", "Hiligayanon" },
            { "hmn", "Hmong" },
            { "hnj", "Hmong Njua" },
            { "hsb", "Upper Sorbian" },
            { "hup", "Hupa" },
            { "hur", "Halkomelem" },
            { "iba", "Iban" },
            { "ibb", "Ibibio" },
            { "ikt", "Westarn Canadian Inuktitut" },
            { "ilo", "Iloko" },
            { "inh", "Ingush" },
            { "jbo", "Lojban" },
            { "jgo", "Ngomba" },
            { "jmc", "Machame" },
            { "kaa", "Kara-Kalpak" },
            { "kab", "Kabyle" },
            { "kac", "Kachin" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "kbd", "Kabadian" },
            { "kcg", "Tyap" },
            { "kde", "Makonde" },
            { "kea", "Kab\u1ee5verd\u1ecban\u1ee5" },
            { "ken", "Kenyang" },
            { "kfo", "Koro" },
            { "kgp", "Kaingang" },
            { "kha", "Khasi" },
            { "khq", "Koyra Chiini" },
            { "kkj", "Kako" },
            { "kln", "Kalenjin" },
            { "kmb", "Kimbundu" },
            { "kok", "Konkani" },
            { "kpe", "Kpelle" },
            { "krc", "Karachay-Balkar" },
            { "krl", "Karelian" },
            { "kru", "Kurukh" },
            { "ksb", "Shambala" },
            { "ksf", "Baf\u1ecba" },
            { "ksh", "Colognian" },
            { "kum", "Kumik" },
            { "kwk", "Kwak\u02bcwala" },
            { "kxv", "Kuvi" },
            { "lad", "Ladino" },
            { "lag", "Lang\u1ecb" },
            { "lez", "Lezghian" },
            { "lij", "Ligurian" },
            { "lil", "Liloet\u1ecb" },
            { "lkt", "Lakota" },
            { "lld", "ID" },
            { "lmo", "Lombard" },
            { "lou", "Louisiana Creole" },
            { "loz", "Lozi" },
            { "lrc", "Northern Luri" },
            { "lsm", "Saamia" },
            { "ltg", "Latgalian" },
            { "lua", "Luba-Lulua" },
            { "lun", "Lunda" },
            { "lus", "Mizo" },
            { "luy", "Luyia" },
            { "mad", "Madurese" },
            { "mag", "Magahi" },
            { "mai", "Maithili" },
            { "mak", metaValue_mak },
            { "mas", "Masai" },
            { "mdf", "Moksha" },
            { "men", metaValue_men },
            { "mer", "Meru" },
            { "mfe", "Morisyen" },
            { "mgh", "Makhuwa-Meetto" },
            { "mgo", "Meta" },
            { "mhn", "mhnn" },
            { "mic", "Mi'kmaw" },
            { "min", "Minangkabau" },
            { "mni", "As\u1ee5s\u1ee5 Manipuri" },
            { "moe", "Innu-aimun" },
            { "moh", "Mohawk" },
            { "mos", "Mossi" },
            { "mua", "Mundang" },
            { "mul", "\u1ecct\u1ee5t\u1ee5 as\u1ee5s\u1ee5" },
            { "mus", "Muscogee" },
            { "mwl", "Mirandese" },
            { "myv", "Erzya" },
            { "mzn", "Mazanderani" },
            { "nap", "Neapolitan" },
            { "naq", "Nama" },
            { "nds", "Low German" },
            { "new", "Newari" },
            { "nia", "Nias" },
            { "niu", "Niuean" },
            { "nmg", "Kwasio" },
            { "nnh", "Ngiemboon" },
            { "nog", "Nogai" },
            { "nqo", metaValue_nqo },
            { "nso", "Northern Sotho" },
            { "nus", "Nuer" },
            { "nyn", "Nyankole" },
            { "ojb", "Northwestern Ojibwa" },
            { "ojc", "Central Ojibwa" },
            { "ojs", "Oji-Cree" },
            { "ojw", "Westarn Ojibwa" },
            { "oka", "Okanagan" },
            { "osa", metaValue_osa },
            { "pag", "Pangasinan" },
            { "pam", "Pampanga" },
            { "pap", "Papiamento" },
            { "pau", "Palauan" },
            { "pcm", "Pidgin nd\u1ecb Naijir\u1ecba" },
            { "pis", "Pijin" },
            { "pqm", "Maliseet-Passamaquoddy" },
            { "prg", "Pr\u1ee5ss\u1ecban" },
            { "quc", "K\u02bciche\u02bc" },
            { "raj", "Rajastani" },
            { "rap", "Rapanui" },
            { "rar", "Rarotongan" },
            { "rhg", "Rohingya" },
            { "rif", "Riffian" },
            { "rof", "Rombo" },
            { "rup", "Aromanian" },
            { "rwk", "Rwa" },
            { "sad", "Sandawe" },
            { "sah", "Yakut" },
            { "saq", "Samburu" },
            { "sat", "As\u1ee5s\u1ee5 Santali" },
            { "sba", "Ngambay" },
            { "sbp", "Sangu" },
            { "scn", "Sicilian" },
            { "sco", "Scots" },
            { "sdh", "Southern Kurdish" },
            { "seh", "Sena" },
            { "ses", "Koyraboro Senni" },
            { "shi", "Tach\u1ecbk\u1ecbt" },
            { "shn", "Shan" },
            { "sid", "Sidamo" },
            { "skr", "skrr" },
            { "slh", "Southern Lushootseed" },
            { "sma", "Southern Sami" },
            { "smj", "Lule Sami" },
            { "smn", "Inari Sami" },
            { "sms", "Skolt sami" },
            { "snk", "Soninke" },
            { "srn", "Sranan Tongo" },
            { "ssy", "Saho" },
            { "str", "Straits Salish" },
            { "suk", "Sukuma" },
            { "swb", "Comorian" },
            { "syr", "Sir\u1ecbak" },
            { "szl", "As\u1ee5s\u1ee5 Sileshia" },
            { "tce", "Southern Tutchone" },
            { "tem", "Timne" },
            { "teo", "Teso" },
            { "tet", "Tetum" },
            { "tgx", "Tagish" },
            { "tht", "Tahitan" },
            { "tig", "Tigre" },
            { "tlh", "Klingon" },
            { "tli", "Tlingit" },
            { "tok", "Toki Pona" },
            { "tpi", "Tok pisin" },
            { "trv", "Taroko" },
            { "trw", "Torwali" },
            { "ttm", "Northern Tutchone" },
            { "tum", "Tumbuka" },
            { "tvl", metaValue_TV },
            { "twq", "Tasawaq" },
            { "tyv", "Tuvinian" },
            { "tzm", "Central Atlas Tamazight" },
            { "udm", "Udmurt" },
            { "umb", "Umbundu" },
            { "und", "As\u1ee5s\u1ee5 a na-amagh\u1ecb" },
            { "vec", "As\u1ee5s\u1ee5 Veneshia" },
            { "vmw", "Makhuwa" },
            { "vun", "Vunjo" },
            { "wae", "Walser" },
            { "wal", "Wolaytta" },
            { "war", "Waray" },
            { "wbp", "Warlpiri" },
            { "wuu", "Wu Chinese" },
            { "xal", "Kalmyk" },
            { "xnr", "Kangri" },
            { "xog", "Soga" },
            { "yav", "Yangben" },
            { "ybb", "Yemba" },
            { "yrl", "As\u1ee5s\u1ee5 Nheengatu" },
            { "yue", "Cantonese" },
            { "zgh", "Standard Moroccan Tamazight" },
            { "zun", "Zuni" },
            { "zxx", "Enwegh\u1ecb as\u1ee5s\u1ee5 d\u1ecbnaya" },
            { "zza", "Zaza" },
            { "Adlm", "Adlam" },
            { "Aghb", "Caucasian Albanian" },
            { "Arab", "Mkp\u1ee5r\u1ee5 Okwu Arabic" },
            { "Aran", "Nastaliq" },
            { "Armi", "Imperial Aramaic" },
            { "Armn", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 Armen\u1ecban" },
            { "Avst", "Avestan" },
            { "Bali", metaValue_ban },
            { "Bamu", "Bamum" },
            { "Bass", "Bassa Vah" },
            { "Batk", "Batak" },
            { "Beng", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 Bangla" },
            { "Bhks", "Bhaiksuki" },
            { "Bopo", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 Bopomofo" },
            { "Brah", "Brahmi" },
            { "Brai", "Braille" },
            { "Bugi", metaValue_bug },
            { "Buhd", "Buhid" },
            { "Cakm", metaValue_ccp },
            { "Cans", "Unified Canadian Aboriginal Syllabics" },
            { "Cari", "Carian" },
            { "Cher", metaValue_chr },
            { "Chrs", "Chorasmian" },
            { "Copt", "Coptic" },
            { "Cpmn", "Cypro-Minoan" },
            { "Cprt", "Cypriot" },
            { "Cyrl", "Cyrillic" },
            { "Cyrs", "Old Church Slavonic Cyrillic" },
            { "Deva", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 Devangar\u1ecb" },
            { "Diak", "Dives Akuru" },
            { "Dogr", "Dogra" },
            { "Dsrt", "Deseret" },
            { "Dupl", "Duployan shorthand" },
            { "Egyp", "Egyptian hieroglyphs" },
            { "Elba", "Elbasan" },
            { "Elym", "Elymaic" },
            { "Ethi", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 Et\u1ecdp\u1ecba" },
            { "Gara", "Garay" },
            { "Geor", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 Ge\u1ecdj\u1ecban" },
            { "Glag", "Glagolitic" },
            { "Gong", "Gunjala Gondi" },
            { "Gonm", "Masaram Gondi" },
            { "Goth", "Gothic" },
            { "Gran", "Grantha" },
            { "Grek", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 gr\u1ecbk" },
            { "Gujr", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 G\u1ee5jarat\u1ecb" },
            { "Gukh", "Gurung Khema" },
            { "Guru", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 G\u1ee5rm\u1ee5k\u1ecb" },
            { "Hanb", "Han na Bopomofo" },
            { "Hang", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 Hang\u1ee5l" },
            { "Hani", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 Han" },
            { "Hano", "Hanunoo" },
            { "Hans", "Nke d\u1ecb mfe" },
            { "Hant", "Omenala" },
            { "Hatr", "Hatran" },
            { "Hebr", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 Hebrew" },
            { "Hira", "Mkp\u1ee5r\u1ee5 okw\u1ee5 H\u1ecbragana" },
            { "Hluw", "Anatolian Hieroglyphs" },
            { "Hmng", "Pahawh Hmong" },
            { "Hmnp", "Nyiakeng Puachue Hmong" },
            { "Hrkt", "mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 Japan\u1ecbs\u1ecb" },
            { "Hung", "Old Hungarian" },
            { "Ital", "Old Italic" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Kali", "Kayah Li" },
            { "Kana", "Katakana" },
            { "Kawi", "KAWI" },
            { "Khar", "Kharoshthi" },
            { "Khmr", metaValue_km },
            { "Khoj", "Khojki" },
            { "Kits", "Khitan small script" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Krai", "Kirat Rai" },
            { "Kthi", "Kaithi" },
            { "Lana", "Lanna" },
            { "Laoo", metaValue_lo },
            { "Latf", "Fraktur Latin" },
            { "Latg", "Gaelic Latin" },
            { "Latn", metaValue_la },
            { "Lepc", "Lepcha" },
            { "Limb", "Limbu" },
            { "Lina", "Linear A" },
            { "Linb", "Linear B" },
            { "Lisu", "Fraser" },
            { "Lyci", "Lycian" },
            { "Lydi", "Lydian" },
            { "Mahj", "Mahajani" },
            { "Maka", metaValue_mak },
            { "Mand", "Mandaean" },
            { "Mani", "Manichaean" },
            { "Marc", "Marchen" },
            { "Medf", "Medefaidrin" },
            { "Mend", metaValue_men },
            { "Merc", "Meroitic Cursive" },
            { "Mero", "Meroitic" },
            { "Mlym", metaValue_ml },
            { "Mong", "Mongolian" },
            { "Mroo", "Mro" },
            { "Mtei", "Meitei Mayek" },
            { "Mult", "Multani" },
            { "Mymr", "Myanmar" },
            { "Nagm", "Nag Mundari" },
            { "Nand", "Nandinagari" },
            { "Narb", "Old North Arabian" },
            { "Nbat", "Nabataean" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "N\u00fcshu" },
            { "Ogam", "Ogham" },
            { "Olck", "Ol Chiki" },
            { "Onao", "Ol Onal" },
            { "Orkh", "Orkhon" },
            { "Orya", "Odia" },
            { "Osge", metaValue_osa },
            { "Osma", "Osmanya" },
            { "Ougr", "Old Uyghur" },
            { "Palm", "Palmyrene" },
            { "Pauc", "Pau Cin Hau" },
            { "Perm", "Old Permic" },
            { "Phag", "Phags-pa" },
            { "Phli", "Inscriptional Pahlavi" },
            { "Phlp", "Psalter Pahlavi" },
            { "Phnx", "Phoenician" },
            { "Plrd", "Pollard Phonetic" },
            { "Prti", "Inscriptional Parthian" },
            { "Qaag", "Zawgyi" },
            { "Rjng", "Rejang" },
            { "Rohg", "Hanifi" },
            { "Runr", "Runic" },
            { "Samr", "Samaritan" },
            { "Sarb", "Old South Arabian" },
            { "Saur", "Saurashtra" },
            { "Sgnw", "SignWriting" },
            { "Shaw", "Shavian" },
            { "Shrd", "Sharada" },
            { "Sidd", "Siddham" },
            { "Sind", "Khudawadi" },
            { "Sinh", metaValue_si },
            { "Sogd", "Sogdian" },
            { "Sogo", "Old Sogdian" },
            { "Sora", "Sora Sompeng" },
            { "Soyo", "Soyombo" },
            { "Sund", "Sundanese" },
            { "Sunu", "Sunuwar" },
            { "Sylo", "Syloti Nagri" },
            { "Syrc", "Siriak" },
            { "Syre", "Estrangelo Syriac" },
            { "Syrj", "Western Syriac" },
            { "Syrn", "Eastern Syriac" },
            { "Tagb", "Tagbanwa" },
            { "Takr", "Takri" },
            { "Tale", "Tai Le" },
            { "Talu", "New Tai Lue" },
            { "Taml", metaValue_ta },
            { "Tang", "Tangut" },
            { "Tavt", "Tai Viet" },
            { "Telu", metaValue_te },
            { "Tfng", "Tifinagh" },
            { "Tglg", "Tagalog" },
            { "Thaa", "Thaana" },
            { "Tibt", metaValue_bo },
            { "Tirh", "Tirhuta" },
            { "Tnsa", "Tangsa" },
            { "Todr", "Todhri" },
            { "Tutg", "Tulu-Tigalari" },
            { "Ugar", "Ugaritic" },
            { "Vaii", "Vai" },
            { "Vith", "Vithkuqi" },
            { "Wara", "Varang Kshiti" },
            { "Wcho", "Wancho" },
            { "Xpeo", "Old Persian" },
            { "Xsux", "Sumero-Akkadian Cuneiform" },
            { "Yezi", "Yezidi" },
            { "Yiii", "Yi" },
            { "Zanb", "Zanabazar Square" },
            { "Zinh", "Inherited" },
            { "Zmth", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 Mgbak\u1ecd" },
            { "Zsye", "Emoji" },
            { "Zsym", "Akara" },
            { "Zxxx", "A na-edegh\u1ecb ede" },
            { "Zyyy", "Common" },
            { "Zzzz", "Edemede a na-amaghi" },
            { "de_AT", "Austrian German" },
            { "de_CH", "Swiss High German" },
            { "en_AU", "Bekee nd\u1ecb Australia" },
            { "en_CA", "Bekee nd\u1ecb Canada" },
            { "en_GB", "Bekee nd\u1ecb United Kingdom" },
            { "en_US", "Bekee nd\u1ecb America" },
            { "es_ES", "Spanish nd\u1ecb Europe" },
            { "es_MX", "Spanish nd\u1ecb Mexico" },
            { "fa_AF", "Dari" },
            { "fr_CA", "Canadian French" },
            { "fr_CH", "Swiss French" },
            { "nl_BE", "Flemish" },
            { "pt_BR", "As\u1ee5s\u1ee5 Portugese nd\u1ecb Brazil" },
            { "pt_PT", "As\u1ee5s\u1ee5 Portuguese nd\u1ecb Europe" },
            { "ro_MD", "Moldavian" },
            { "ar_001", "\u1ee4d\u1ecb Arabiik\u1ecb nke oge a" },
            { "es_419", "Spanish nd\u1ecb Latin America" },
            { "key.ca", "Kalenda" },
            { "key.cf", "\u1ee4s\u1ecdr\u1ecd eg\u1ecd" },
            { "key.co", "\u1ee4s\u1ecdr\u1ecd Nhaz\u1ecb" },
            { "key.cu", "Eg\u1ecd" },
            { "key.hc", "Ok\u1ecbr\u1ecbk\u1ecbr\u1ecb Awa (12 vs 24)" },
            { "key.lb", "Akara akanka nkw\u1ee5s\u1ecb" },
            { "key.ms", "\u1ee4s\u1ecdr\u1ecd Mmesh\u1ecd" },
            { "key.nu", "N\u1ecdmba" },
            { "nds_NL", "Low Saxon" },
            { "zh_Hans", "As\u1ee5s\u1ee5 Cha\u1ecbniiz d\u1ecb mfe" },
            { "zh_Hant", "As\u1ee5s\u1ee5 \u1ecdd\u1ecbnala Cha\u1ecbniiz" },
            { "type.ca.roc", "Kalenda rep\u1ee5blic nke China" },
            { "type.hc.h11", "\u1ee4s\u1ecdr\u1ecd Ok\u1ecbr\u1ecbk\u1ecbr\u1ecb awa iri na ab\u1ee5\u1ecd (0\u201311)" },
            { "type.hc.h12", "\u1ee4s\u1ecdr\u1ecd Ok\u1ecbr\u1ecbk\u1ecbr\u1ecb awa iri na ab\u1ee5\u1ecd (0\u201312)" },
            { "type.hc.h23", "\u1ee4s\u1ecdr\u1ecd Ok\u1ecbr\u1ecbk\u1ecbr\u1ecb (0\u201323)" },
            { "type.hc.h24", "\u1ee4s\u1ecdr\u1ecd Ok\u1ecbr\u1ecbk\u1ecbr\u1ecb (1\u201324)" },
            { "type.nu.ahom", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Ahom" },
            { "type.nu.arab", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Arab na Ind\u1ecb" },
            { "type.nu.armn", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Armen\u1ecba" },
            { "type.nu.bali", "Balinese Digits" },
            { "type.nu.beng", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Bangla" },
            { "type.nu.brah", "Brahmi Digits" },
            { "type.nu.cakm", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Chakma" },
            { "type.nu.cham", "Cham Digits" },
            { "type.nu.cyrl", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Cyrillic" },
            { "type.nu.deva", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Devanagar\u1ecb" },
            { "type.nu.diak", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Dives Akuru" },
            { "type.nu.ethi", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Et\u1ecdp\u1ecba" },
            { "type.nu.gara", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Garay" },
            { "type.nu.geor", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Georgian" },
            { "type.nu.gong", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Gunjala Gondi" },
            { "type.nu.gonm", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Masaram Gondi" },
            { "type.nu.grek", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Grik" },
            { "type.nu.gujr", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 G\u1ee5jarat\u1ecb" },
            { "type.nu.gukh", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Gurung Khema" },
            { "type.nu.guru", "On\u1ee5 \u1ecdg\u1ee5g\u1ee5 G\u1ee5m\u1ee5kh" },
            { "type.nu.hans", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 mfe Ch\u1ecbnese" },
            { "type.nu.hant", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 \u1ecddinala chinese" },
            { "type.nu.hebr", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Hebrew" },
            { "type.nu.hmng", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Pahawh Hmong" },
            { "type.nu.hmnp", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Nyiakeng Puachue Hmong" },
            { "type.nu.java", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Javan\u1ecbs\u1ecb" },
            { "type.nu.jpan", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Japanese" },
            { "type.nu.kali", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Kayah Li" },
            { "type.nu.kawi", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Kawi" },
            { "type.nu.khmr", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Khmer" },
            { "type.nu.knda", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Kannada" },
            { "type.nu.krai", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Kirat Rai" },
            { "type.nu.lana", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Tai Tham Hora" },
            { "type.nu.laoo", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Lao" },
            { "type.nu.latn", "\u1eccn\u1ee5 \u1eccg\u1ee5g\u1ee5 Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5" },
            { "type.nu.lepc", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Lepcha" },
            { "type.nu.limb", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Limbu" },
            { "type.nu.mlym", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Malayala" },
            { "type.nu.modi", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Modi" },
            { "type.nu.mong", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Mongolian" },
            { "type.nu.mroo", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Mro" },
            { "type.nu.mtei", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Meetei Mayek" },
            { "type.nu.mymr", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Myamar" },
            { "type.nu.nagm", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Nag Mundari" },
            { "type.nu.nkoo", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 N\u2019Ko" },
            { "type.nu.olck", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Ochiki" },
            { "type.nu.onao", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Ol Onal" },
            { "type.nu.orya", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 \u1eccd\u1ecba" },
            { "type.nu.osma", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Osmanya" },
            { "type.nu.rohg", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Hanifi Rohingya" },
            { "type.nu.saur", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Saurashtra" },
            { "type.nu.shrd", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Sharada" },
            { "type.nu.sind", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Khudawadi" },
            { "type.nu.sinh", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Sinhala Lith" },
            { "type.nu.sora", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Sora Sompeng" },
            { "type.nu.sund", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Sundanese" },
            { "type.nu.sunu", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Sunuwar" },
            { "type.nu.takr", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Takri" },
            { "type.nu.talu", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 New Tai Lue" },
            { "type.nu.taml", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 \u1ecdd\u1ecbnala Tam\u1ecbl" },
            { "type.nu.telu", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Tel\u1ee5g\u1ee5" },
            { "type.nu.thai", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Ta\u1ecb" },
            { "type.nu.tibt", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 T\u1ecbbeta" },
            { "type.nu.tirh", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Tirhuta" },
            { "type.nu.tnsa", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Tangsa" },
            { "type.nu.vaii", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Vai" },
            { "type.nu.wara", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Warang Citi" },
            { "type.nu.wcho", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Wancho" },
            { "type.ca.dangi", "Kalenda Dang" },
            { "type.co.ducet", "Default Unicode \u1ee5s\u1ecdr\u1ecd nhaz\u1ecb" },
            { "type.lb.loose", "Akara akanka nkw\u1ee5s\u1ecb es\u1ecbgh\u1ecb \u1ecbke" },
            { "type.nu.roman", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Roman" },
            { "type.ca.coptic", "Kalenda Koptic" },
            { "type.ca.hebrew", "Kalenda Hebrew" },
            { "type.ca.indian", "Kalenda India" },
            { "type.co.pinyin", "Pinyin \u1ee5s\u1ecdr\u1ecd nhaz\u1ecb" },
            { "type.co.search", "\u1eccch\u1ee5ch\u1ee5 n\u1ecble" },
            { "type.lb.normal", "Akara akanka nkw\u1ee5s\u1ecb kwes\u1ecbr\u1ecb" },
            { "type.lb.strict", "Akara akanka nkw\u1ee5s\u1ecb s\u1ecbr\u1ecb \u1ecbke" },
            { "type.ms.metric", "\u1ee4s\u1ecdr\u1ecd Metric" },
            { "type.ca.chinese", "Kalenda Chinese" },
            { "type.ca.islamic", metaValue_type_ca_islamic },
            { "type.ca.iso8601", "Kalenda ISO-8601" },
            { "type.ca.persian", "Kalenda Persian" },
            { "type.cf.account", "\u1ee4s\u1ecdr\u1ecd akant\u1ee5 eg\u1ecd" },
            { "type.nu.arabext", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Arab na Ind\u1ecb agbat\u1ecbr\u1ecb" },
            { "type.nu.armnlow", "\u1ecdbere \u1ecdn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Armen\u1ecba" },
            { "type.nu.greklow", "\u1eccbere \u1ecdn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Grik" },
            { "type.nu.hanidec", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 nt\u1ee5p\u1ecd Ch\u1ecbnese" },
            { "type.nu.hansfin", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 akant\u1ee5 mfe nke Chinese" },
            { "type.nu.hantfin", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 akant\u1ee5 \u1ecdd\u1ecbnala Chinese" },
            { "type.nu.jpanfin", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 akant\u1ee5 Japanese" },
            { "type.nu.mathdbl", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Mathematical Double-Struck" },
            { "type.nu.mymrpao", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Myanmar Pao" },
            { "type.nu.tamldec", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Tam\u1ecb" },
            { "type.ca.buddhist", "Kalenda B\u1ee5dd\u1ecbst" },
            { "type.ca.ethiopic", "Kalenda Etop\u1ecba" },
            { "type.ca.japanese", "Kalenda Japanese" },
            { "type.cf.standard", "\u1ee4s\u1ecdr\u1ecd eg\u1ecd nz\u1ee5gbe" },
            { "type.co.standard", "Usoro Nhazi" },
            { "type.ms.uksystem", "\u1ee4s\u1ecdr\u1ecd Mmesh\u1ecd \u1ecbmper\u1ecba" },
            { "type.ms.ussystem", "\u1ee4s\u1ecdr\u1ecd Mmesh\u1ecd US" },
            { "type.nu.fullwide", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 \u1ecdb\u1ecdsara" },
            { "type.nu.lanatham", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Tai Tham Tham" },
            { "type.nu.mathbold", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Mathematical Bold" },
            { "type.nu.mathmono", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Mathematical Monospace" },
            { "type.nu.mathsanb", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Mathematical Sans-Serif Bold" },
            { "type.nu.mathsans", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Mathematical Sans-Serif" },
            { "type.nu.mymrepka", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Myanmar Eastern Pwo Karen" },
            { "type.nu.mymrshan", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Myanmar Shan" },
            { "type.nu.mymrtlng", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Myanmar Tai Laing" },
            { "type.nu.outlined", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Outlined" },
            { "type.nu.romanlow", "\u1eccbere \u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Roman" },
            { "type.ca.gregorian", "Kalenda Gregory" },
            { "type.co.phonebook", "Nhaz\u1ecb akw\u1ee5kw\u1ecd ebe a na-ede n\u1ecdmba fon" },
            { "type.ca.islamic-rgsa", "Kalenda Hijri (Saudi Arabia, sighting)" },
            { "type.ca.islamic-tbla", "Kalenda Hijri (tabular, astronomical epoch)" },
            { "type.ca.islamic-civil", metaValue_type_ca_islamic },
            { "type.ca.islamic-umalqura", "Kalenda Hijri (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Etiopic Amete Alem Kalenda" },
        };
        return data;
    }
}
