/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_fil extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "Nauru";
        final String metaValue_TV = "Tuvalu";
        final String metaValue_ar = "Arabic";
        final String metaValue_hy = "Armenian";
        final String metaValue_bn = "Bangla";
        final String metaValue_ccp = "Chakma";
        final String metaValue_chr = "Cherokee";
        final String metaValue_ka = "Georgian";
        final String metaValue_el = "Greek";
        final String metaValue_gu = "Gujarati";
        final String metaValue_he = "Hebrew";
        final String metaValue_ja = "Japanese";
        final String metaValue_km = "Khmer";
        final String metaValue_kn = "Kannada";
        final String metaValue_ko = "Korean";
        final String metaValue_lo = "Lao";
        final String metaValue_la = "Latin";
        final String metaValue_ml = "Malayalam";
        final String metaValue_mn = "Mongolian";
        final String metaValue_nqo = "N\u2019Ko";
        final String metaValue_or = "Odia";
        final String metaValue_si = "Sinhala";
        final String metaValue_su = "Sundanese";
        final String metaValue_syr = "Syriac";
        final String metaValue_ta = "Tamil";
        final String metaValue_te = "Telugu";
        final String metaValue_th = "Thai";
        final String metaValue_bo = "Tibetan";
        final String metaValue_vai = "Vai";
        final Object[][] data = new Object[][] {
            { "001", "Mundo" },
            { "002", "Africa" },
            { "003", "Hilagang Amerika" },
            { "005", "Timog Amerika" },
            { "009", "Oceania" },
            { "011", "Kanlurang Africa" },
            { "013", "Gitnang Amerika" },
            { "014", "Silangang Africa" },
            { "015", "Hilagang Africa" },
            { "017", "Gitnang Africa" },
            { "018", "Katimugang Africa" },
            { "019", "Americas" },
            { "021", "Northern America" },
            { "029", "Carribbean" },
            { "030", "Silangang Asya" },
            { "034", "Katimugang Asya" },
            { "035", "Timog-Silangang Asya" },
            { "039", "Katimugang Europe" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "057", "Rehiyon ng Micronesia" },
            { "061", "Polynesia" },
            { "142", "Asya" },
            { "143", "Gitnang Asya" },
            { "145", "Kanlurang Asya" },
            { "150", "Europe" },
            { "151", "Silangang Europe" },
            { "154", "Hilagang Europe" },
            { "155", "Kanlurang Europe" },
            { "202", "Sub-Saharan Africa" },
            { "419", "Latin America" },
            { "AC", "Acsencion island" },
            { "AD", "Andorra" },
            { "AE", "United Arab Emirates" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua & Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antarctica" },
            { "AR", "Argentina" },
            { "AS", "American Samoa" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "\u00c5land Islands" },
            { "AZ", "Azerbaijan" },
            { "BA", "Bosnia and Herzegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgium" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "St. Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Caribbean Netherlands" },
            { "BR", "Brazil" },
            { "BS", "Bahamas" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet Island" },
            { "BW", "Botswana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "CA", "Canada" },
            { "CC", "Cocos (Keeling) Islands" },
            { "CD", "Congo - Kinshasa" },
            { "CF", "Central African Republic" },
            { "CG", "Congo - Brazzaville" },
            { "CH", "Switzerland" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Cook Islands" },
            { "CL", "Chile" },
            { "CM", "Cameroon" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "CP", "Clipperton Island" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cape Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Christmas Island" },
            { "CY", "Cyprus" },
            { "CZ", "Czechia" },
            { "DE", "Germany" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Denmark" },
            { "DM", "Dominica" },
            { "DO", "Dominican Republic" },
            { "DZ", "Algeria" },
            { "EA", "Ceuta & Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estonia" },
            { "EG", "Egypt" },
            { "EH", "Kanlurang Sahara" },
            { "ER", "Eritrea" },
            { "ES", "Spain" },
            { "ET", "Ethiopia" },
            { "EU", "European Union" },
            { "EZ", "Eurozone" },
            { "FI", "Finland" },
            { "FJ", "Fiji" },
            { "FK", "Falkland Islands" },
            { "FM", "Micronesia" },
            { "FO", "Faroe Islands" },
            { "FR", "France" },
            { "GA", "Gabon" },
            { "GB", "United Kingdom" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "French Guiana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Greenland" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Equatorial Guinea" },
            { "GR", "Greece" },
            { "GS", "South Georgia & South Sandwich Islands" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hong Kong SAR China" },
            { "HM", "Heard & McDonald Islands" },
            { "HN", "Honduras" },
            { "HR", "Croatia" },
            { "HT", "Haiti" },
            { "HU", "Hungary" },
            { "IC", "Canary Islands" },
            { "ID", "Indonesia" },
            { "IE", "Ireland" },
            { "IL", "Israel" },
            { "IM", "Isle of Man" },
            { "IN", "India" },
            { "IO", "British Indian Ocean Territory" },
            { "IQ", "Iraq" },
            { "IR", "Iran" },
            { "IS", "Iceland" },
            { "IT", "Italy" },
            { "JE", "Jersey" },
            { "JM", "Jamaica" },
            { "JO", "Jordan" },
            { "JP", "Japan" },
            { "KE", "Kenya" },
            { "KG", "Kyrgyzstan" },
            { "KH", "Cambodia" },
            { "KI", "Kiribati" },
            { "KM", "Comoros" },
            { "KN", "St. Kitts & Nevis" },
            { "KP", "Hilagang Korea" },
            { "KR", "Timog Korea" },
            { "KW", "Kuwait" },
            { "KY", "Cayman Islands" },
            { "KZ", "Kazakhstan" },
            { "LA", "Laos" },
            { "LB", "Lebanon" },
            { "LC", "Saint Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lithuania" },
            { "LU", "Luxembourg" },
            { "LV", "Latvia" },
            { "LY", "Libya" },
            { "MA", "Morocco" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "MG", "Madagascar" },
            { "MH", "Marshall Islands" },
            { "MK", "North Macedonia" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongolia" },
            { "MO", "Macau SAR China" },
            { "MP", "Northern Mariana Islands" },
            { "MQ", "Martinique" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Maldives" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambique" },
            { "NA", "Namibia" },
            { "NC", "New Caledonia" },
            { "NE", "Niger" },
            { "NF", "Norfolk Island" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Netherlands" },
            { "NO", "Norway" },
            { "NP", "Nepal" },
            { "NR", metaValue_NR },
            { "NU", "Niue" },
            { "NZ", "New Zealand" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "French Polynesia" },
            { "PG", "Papua New Guinea" },
            { "PH", "Pilipinas" },
            { "PK", "Pakistan" },
            { "PL", "Poland" },
            { "PM", "St. Pierre & Miquelon" },
            { "PN", "Pitcairn Islands" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestinian Territories" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "Outlying Oceania" },
            { "RE", "R\u00e9union" },
            { "RO", "Romania" },
            { "RS", "Serbia" },
            { "RU", "Russia" },
            { "RW", "Rwanda" },
            { "SA", "Saudi Arabia" },
            { "SB", "Solomon Islands" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "SE", "Sweden" },
            { "SG", "Singapore" },
            { "SH", "St. Helena" },
            { "SI", "Slovenia" },
            { "SJ", "Svalbard & Jan Mayen" },
            { "SK", "Slovakia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Suriname" },
            { "SS", "Timog Sudan" },
            { "ST", "S\u00e3o Tom\u00e9 & Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syria" },
            { "SZ", "Swaziland" },
            { "TA", "Tristan de Cunha" },
            { "TC", "Turks & Caicos Islands" },
            { "TD", "Chad" },
            { "TF", "French Southern Territories" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tajikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "TR", "Turkey" },
            { "TT", "Trinidad & Tobago" },
            { "TV", metaValue_TV },
            { "TW", "Taiwan" },
            { "TZ", "Tanzania" },
            { "UA", "Ukraine" },
            { "UG", "Uganda" },
            { "UM", "U.S. Outlying Islands" },
            { "UN", "United Nations" },
            { "US", "Estados Unidos" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekistan" },
            { "VA", "Vatican City" },
            { "VC", "St. Vincent & Grenadines" },
            { "VE", "Venezuela" },
            { "VG", "British Virgin Islands" },
            { "VI", "U.S. Virgin Islands" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis & Futuna" },
            { "WS", "Samoa" },
            { "XA", "Mga Pseudo-Accent" },
            { "XB", "Pseudo-Bidi" },
            { "XK", "Kosovo" },
            { "YE", "Yemen" },
            { "YT", "Mayotte" },
            { "ZA", "South Africa" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Hindi Kilalang Rehiyon" },
            { "aa", "Afar" },
            { "ab", "Abkhazian" },
            { "af", "Afrikaans" },
            { "ak", "Akan" },
            { "am", "Amharic" },
            { "an", "Aragonese" },
            { "ar", metaValue_ar },
            { "as", "Assamese" },
            { "av", "Avaric" },
            { "ay", "Aymara" },
            { "az", "Azerbaijani" },
            { "ba", "Bashkir" },
            { "be", "Belarusian" },
            { "bg", "Bulgarian" },
            { "bi", "Bislama" },
            { "bm", "Bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "Breton" },
            { "bs", "Bosnian" },
            { "ca", "Catalan" },
            { "ce", "Chechen" },
            { "ch", "Chamorro" },
            { "co", "Corsican" },
            { "cs", "Czech" },
            { "cu", "Church Slavic" },
            { "cv", "Chuvash" },
            { "cy", "Welsh" },
            { "da", "Danish" },
            { "de", "German" },
            { "dv", "Divehi" },
            { "dz", "Dzongkha" },
            { "ee", "Ewe" },
            { "el", metaValue_el },
            { "en", "Ingles" },
            { "eo", "Esperanto" },
            { "es", "Spanish" },
            { "et", "Estonian" },
            { "eu", "Basque" },
            { "fa", "Persian" },
            { "ff", "Fulah" },
            { "fi", "Finnish" },
            { "fj", "Fijian" },
            { "fo", "Faroese" },
            { "fr", "French" },
            { "fy", "Kanlurang Frisian" },
            { "ga", "Irish" },
            { "gd", "Scottish Gaelic" },
            { "gl", "Galician" },
            { "gn", "Guarani" },
            { "gu", metaValue_gu },
            { "gv", "Manx" },
            { "ha", "Hausa" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "hr", "Croatian" },
            { "ht", "Haitian" },
            { "hu", "Hungarian" },
            { "hy", metaValue_hy },
            { "hz", "Herero" },
            { "ia", "Interlingua" },
            { "id", "Indonesian" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", "Sichuan Yi" },
            { "io", "Ido" },
            { "is", "Icelandic" },
            { "it", "Italian" },
            { "iu", "Inuktitut" },
            { "ja", metaValue_ja },
            { "jv", "Javanese" },
            { "ka", metaValue_ka },
            { "kg", "Kongo" },
            { "ki", "Kikuyu" },
            { "kj", "Kuanyama" },
            { "kk", "Kazakh" },
            { "kl", "Kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "Kanuri" },
            { "ks", "Kashmiri" },
            { "ku", "Kurdish" },
            { "kv", "Komi" },
            { "kw", "Cornish" },
            { "ky", "Kirghiz" },
            { "la", metaValue_la },
            { "lb", "Luxembourgish" },
            { "lg", "Ganda" },
            { "li", "Limburgish" },
            { "ln", "Lingala" },
            { "lo", metaValue_lo },
            { "lt", "Lithuanian" },
            { "lu", "Luba-Katanga" },
            { "lv", "Latvian" },
            { "mg", "Malagasy" },
            { "mh", "Marshallese" },
            { "mi", "M\u0101ori" },
            { "mk", "Macedonian" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "Marathi" },
            { "ms", "Malay" },
            { "mt", "Maltese" },
            { "my", "Burmese" },
            { "na", metaValue_NR },
            { "nb", "Norwegian Bokm\u00e5l" },
            { "nd", "Hilagang Ndebele" },
            { "ne", "Nepali" },
            { "ng", "Ndonga" },
            { "nl", "Dutch" },
            { "nn", "Norwegian Nynorsk" },
            { "no", "Norwegian" },
            { "nr", "South Ndebele" },
            { "nv", "Navajo" },
            { "ny", "Nyanja" },
            { "oc", "Occitan" },
            { "om", "Oromo" },
            { "or", metaValue_or },
            { "os", "Ossetic" },
            { "pa", "Punjabi" },
            { "pl", "Polish" },
            { "ps", "Pashto" },
            { "pt", "Portuguese" },
            { "qu", "Quechua" },
            { "rm", "Romansh" },
            { "rn", "Rundi" },
            { "ro", "Romanian" },
            { "ru", "Russian" },
            { "rw", "Kinyarwanda" },
            { "sa", "Sanskrit" },
            { "sc", "Sardinian" },
            { "sd", "Sindhi" },
            { "se", "Hilagang Sami" },
            { "sg", "Sango" },
            { "sh", "Serbo-Croatian" },
            { "si", metaValue_si },
            { "sk", "Slovak" },
            { "sl", "Slovenian" },
            { "sm", "Samoan" },
            { "sn", "Shona" },
            { "so", "Somali" },
            { "sq", "Albanian" },
            { "sr", "Serbian" },
            { "ss", "Swati" },
            { "st", "Katimugang Sotho" },
            { "su", metaValue_su },
            { "sv", "Swedish" },
            { "sw", "Swahili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "Tajik" },
            { "th", metaValue_th },
            { "ti", "Tigrinya" },
            { "tk", "Turkmen" },
            { "tl", "Tagalog" },
            { "tn", "Tswana" },
            { "to", "Tongan" },
            { "tr", "Turkish" },
            { "ts", "Tsonga" },
            { "tt", "Tatar" },
            { "tw", "Twi" },
            { "ty", "Tahitian" },
            { "ug", "Uyghur" },
            { "uk", "Ukranian" },
            { "ur", "Urdu" },
            { "uz", "Uzbek" },
            { "ve", "Venda" },
            { "vi", "Vietnamese" },
            { "vo", "Volap\u00fck" },
            { "wa", "Walloon" },
            { "wo", "Wolof" },
            { "xh", "Xhosa" },
            { "yi", "Yiddish" },
            { "yo", "Yoruba" },
            { "zh", "Chinese" },
            { "zu", "Zulu" },
            { "ace", "Achinese" },
            { "ach", "Acoli" },
            { "ada", "Adangme" },
            { "ady", "Adyghe" },
            { "agq", "Aghem" },
            { "ain", "Ainu" },
            { "ale", "Aleut" },
            { "alt", "Southern Altai" },
            { "ann", "Obolo" },
            { "anp", "Angika" },
            { "arn", "Mapuche" },
            { "arp", "Arapaho" },
            { "ars", "Najdi Arabic" },
            { "asa", "Asu" },
            { "ast", "Asturian" },
            { "atj", "Atikamekw" },
            { "awa", "Awadhi" },
            { "ban", "Balinese" },
            { "bas", "Basaa" },
            { "bem", "Bemba" },
            { "bez", "Bena" },
            { "bgn", "Kanlurang Balochi" },
            { "bho", "Bhojpuri" },
            { "bin", "Bini" },
            { "bla", "Siksika" },
            { "brx", "Bodo" },
            { "bug", "Buginese" },
            { "byn", "Blin" },
            { "cay", "Cayuga" },
            { "ccp", metaValue_ccp },
            { "ceb", "Cebuano" },
            { "cgg", "Chiga" },
            { "chk", "Chuukese" },
            { "chm", "Mari" },
            { "cho", "Choctaw" },
            { "chp", "Chipewyan" },
            { "chr", metaValue_chr },
            { "chy", "Cheyenne" },
            { "ckb", "Central Kurdish" },
            { "clc", "Chilcotin" },
            { "crg", "Michif" },
            { "crj", "Southern East Cree" },
            { "crk", "Plains Cree" },
            { "crl", "Northern East Cree" },
            { "crm", "Moose Cree" },
            { "crr", "Carolina Algonquian" },
            { "crs", "Seselwa Creole French" },
            { "csw", "Latian na Cree" },
            { "dak", "Dakota" },
            { "dar", "Dargwa" },
            { "dav", "Taita" },
            { "dgr", "Dogrib" },
            { "dje", "Zarma" },
            { "doi", "Dogri" },
            { "dsb", "Lower Sorbian" },
            { "dua", "Duala" },
            { "dyo", "Jola-Fonyi" },
            { "dzg", "Dazaga" },
            { "ebu", "Embu" },
            { "efi", "Efik" },
            { "eka", "Ekajuk" },
            { "ewo", "Ewondo" },
            { "fil", "Filipino" },
            { "fon", "Fon" },
            { "frc", "Cajun French" },
            { "frr", "Hilagang Frisian" },
            { "fur", "Friulian" },
            { "gaa", "Ga" },
            { "gag", "Gagauz" },
            { "gez", "Geez" },
            { "gil", "Gilbertese" },
            { "gor", "Gorontalo" },
            { "gsw", "Swiss German" },
            { "guz", "Gusii" },
            { "gwi", "Gwich\u02bcin" },
            { "hai", "Haida" },
            { "haw", "Hawaiian" },
            { "hax", "Katimugang Haida" },
            { "hil", "Hiligaynon" },
            { "hmn", "Hmong" },
            { "hsb", "Upper Sorbian" },
            { "hup", "Hupa" },
            { "hur", "Halkomelem" },
            { "iba", "Iban" },
            { "ibb", "Ibibio" },
            { "ikt", "Kanlurang Canadian Inuktitut" },
            { "ilo", "Iloko" },
            { "inh", "Ingush" },
            { "jbo", "Lojban" },
            { "jgo", "Ngomba" },
            { "jmc", "Machame" },
            { "kab", "Kabyle" },
            { "kac", "Kachin" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "kbd", "Kabardian" },
            { "kcg", "Tyap" },
            { "kde", "Makonde" },
            { "kea", "Kabuverdianu" },
            { "kfo", "Koro" },
            { "kgp", "Kaingang" },
            { "kha", "Khasi" },
            { "khq", "Koyra Chiini" },
            { "kkj", "Kako" },
            { "kln", "Kalenjin" },
            { "kmb", "Kimbundu" },
            { "koi", "Komi-Permyak" },
            { "kok", "Konkani" },
            { "kpe", "Kpelle" },
            { "krc", "Karachay-Balkar" },
            { "krl", "Karelian" },
            { "kru", "Kurukh" },
            { "ksb", "Shambala" },
            { "ksf", "Bafia" },
            { "ksh", "Colognian" },
            { "kum", "Kumyk" },
            { "kwk", "Kwak\u02bcwala" },
            { "lad", "Ladino" },
            { "lag", "Langi" },
            { "lez", "Lezghian" },
            { "lil", "Lillooet" },
            { "lkt", "Lakota" },
            { "lou", "Louisiana Creole" },
            { "loz", "Lozi" },
            { "lrc", "Hilagang Luri" },
            { "lsm", "Saamia" },
            { "lua", "Luba-Lulua" },
            { "lun", "Lunda" },
            { "luo", "Luo" },
            { "lus", "Mizo" },
            { "luy", "Luyia" },
            { "mad", "Madurese" },
            { "mag", "Magahi" },
            { "mai", "Maithili" },
            { "mak", "Makasar" },
            { "mas", "Masai" },
            { "mdf", "Moksha" },
            { "men", "Mende" },
            { "mer", "Meru" },
            { "mfe", "Morisyen" },
            { "mgh", "Makhuwa-Meetto" },
            { "mgo", "Meta\u2019" },
            { "mic", "Micmac" },
            { "min", "Minangkabau" },
            { "mni", "Manipuri" },
            { "moe", "Innu-aimun" },
            { "moh", "Mohawk" },
            { "mos", "Mossi" },
            { "mua", "Mundang" },
            { "mul", "Maramihang Wika" },
            { "mus", "Creek" },
            { "mwl", "Mirandese" },
            { "myv", "Erzya" },
            { "mzn", "Mazanderani" },
            { "nap", "Neapolitan" },
            { "naq", "Nama" },
            { "nds", "Low German" },
            { "new", "Newari" },
            { "nia", "Nias" },
            { "niu", "Niuean" },
            { "nmg", "Kwasio" },
            { "nnh", "Ngiemboon" },
            { "nog", "Nogai" },
            { "nqo", metaValue_nqo },
            { "nso", "Hilagang Sotho" },
            { "nus", "Nuer" },
            { "nyn", "Nyankole" },
            { "ojb", "Hilagang-Kanluran ng Ojibwa" },
            { "ojc", "Central Ojibwa" },
            { "ojs", "Oji-Cree" },
            { "ojw", "Kanlurang Ojibwa" },
            { "oka", "Okanagan" },
            { "pag", "Pangasinan" },
            { "pam", "Pampanga" },
            { "pap", "Papiamento" },
            { "pau", "Palauan" },
            { "pcm", "Nigerian Pidgin" },
            { "pis", "Pijin" },
            { "pqm", "Maliseet-Passamaquoddy" },
            { "prg", "Prussian" },
            { "quc", "K\u02bciche\u02bc" },
            { "rap", "Rapanui" },
            { "rar", "Rarotongan" },
            { "rhg", "Rohingya" },
            { "rof", "Rombo" },
            { "rup", "Aromanian" },
            { "rwk", "Rwa" },
            { "sad", "Sandawe" },
            { "sah", "Sakha" },
            { "saq", "Samburu" },
            { "sat", "Santali" },
            { "sba", "Ngambay" },
            { "sbp", "Sangu" },
            { "scn", "Sicilian" },
            { "sco", "Scots" },
            { "sdh", "Katimugang Kurdish" },
            { "seh", "Sena" },
            { "ses", "Koyraboro Senni" },
            { "shi", "Tachelhit" },
            { "shn", "Shan" },
            { "slh", "Katimugang Lushootseed" },
            { "sma", "Katimugang Sami" },
            { "smj", "Lule Sami" },
            { "smn", "Inari Sami" },
            { "sms", "Skolt Sami" },
            { "snk", "Soninke" },
            { "srn", "Sranan Tongo" },
            { "ssy", "Saho" },
            { "str", "Straits Salish" },
            { "suk", "Sukuma" },
            { "swb", "Comorian" },
            { "syr", metaValue_syr },
            { "tce", "Katimugang Tutchone" },
            { "tem", "Timne" },
            { "teo", "Teso" },
            { "tet", "Tetum" },
            { "tgx", "Tagish" },
            { "tht", "Tahltan" },
            { "tig", "Tigre" },
            { "tlh", "Klingon" },
            { "tli", "Tlingit" },
            { "tok", "Toki Pona" },
            { "tpi", "Tok Pisin" },
            { "trv", "Taroko" },
            { "ttm", "Northern Tutchone" },
            { "tum", "Tumbuka" },
            { "tvl", metaValue_TV },
            { "twq", "Tasawaq" },
            { "tyv", "Tuvinian" },
            { "tzm", "Central Atlas Tamazight" },
            { "udm", "Udmurt" },
            { "umb", "Umbundu" },
            { "und", "Hindi Kilalang Wika" },
            { "vai", metaValue_vai },
            { "vun", "Vunjo" },
            { "wae", "Walser" },
            { "wal", "Wolaytta" },
            { "war", "Waray" },
            { "wbp", "Warlpiri" },
            { "wuu", "Wu Chinese" },
            { "xal", "Kalmyk" },
            { "xog", "Soga" },
            { "yav", "Yangben" },
            { "ybb", "Yemba" },
            { "yrl", "Nheengatu" },
            { "yue", "Cantonese" },
            { "zgh", "Standard Moroccan Tamazight" },
            { "zun", "Zuni" },
            { "zxx", "Walang nilalaman na ukol sa wika" },
            { "zza", "Zaza" },
            { "Adlm", "Adlam" },
            { "Arab", metaValue_ar },
            { "Aran", "Nastaliq" },
            { "Armn", metaValue_hy },
            { "Beng", metaValue_bn },
            { "Bopo", "Bopomofo" },
            { "Brai", "Braille" },
            { "Cakm", metaValue_ccp },
            { "Cans", "Unified Canadian Aboriginal Syllabics" },
            { "Cher", metaValue_chr },
            { "Cyrl", "Cyrillic" },
            { "Deva", "Devanagari" },
            { "Ethi", "Ethiopic" },
            { "Geor", metaValue_ka },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "Gurmukhi" },
            { "Hanb", "Han na may Bopomofo" },
            { "Hang", "Hangul" },
            { "Hani", "Han" },
            { "Hans", "Pinasimple" },
            { "Hant", "Tradisyonal" },
            { "Hebr", metaValue_he },
            { "Hira", "Hiragana" },
            { "Hrkt", "Japanese syllabaries" },
            { "Jamo", "Jamo" },
            { "Jpan", metaValue_ja },
            { "Kana", "Katakana" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_lo },
            { "Latn", metaValue_la },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Mtei", "Meitei Mayek" },
            { "Mymr", "Myanmar" },
            { "Nkoo", metaValue_nqo },
            { "Olck", "Ol Chiki" },
            { "Orya", metaValue_or },
            { "Rohg", "Hanifi" },
            { "Sinh", metaValue_si },
            { "Sund", metaValue_su },
            { "Syrc", metaValue_syr },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Tfng", "Tifinagh" },
            { "Thaa", "Thaana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Vaii", metaValue_vai },
            { "Yiii", "Yi" },
            { "Zmth", "Mathematical Notation" },
            { "Zsye", "Emoji" },
            { "Zsym", "Mga Simbolo" },
            { "Zxxx", "Hindi Nakasulat" },
            { "Zyyy", "Karaniwan" },
            { "Zzzz", "Hindi Kilalang Script" },
            { "de_CH", "Swiss High German" },
            { "en_GB", "Ingles na British" },
            { "en_US", "Ingles na American" },
            { "es_ES", "European Spanish" },
            { "es_MX", "Mexican na Espanyol" },
            { "fa_AF", "Dari" },
            { "fr_CH", "Swiss na French" },
            { "nl_BE", "Flemish" },
            { "pt_BR", "Portuges ng Brasil" },
            { "pt_PT", "European Portuguese" },
            { "ro_MD", "Moldavian" },
            { "sw_CD", "Congo Swahili" },
            { "ar_001", "Modernong Karaniwang Arabic" },
            { "es_419", "Latin American na Espanyol" },
            { "key.ca", "Kalendaryo" },
            { "key.cf", "Format ng Pera" },
            { "key.co", "Pagkakasunud-sunod ng Ayos" },
            { "key.cu", "Pera" },
            { "key.hc", "Siklo ng Oras (12 laban sa 24)" },
            { "key.lb", "Istilo ng Putol ng Linya" },
            { "key.ms", "Sistema ng Pagsukat" },
            { "key.nu", "Mga Numero" },
            { "key.tz", "Time Zone" },
            { "key.va", "Lokal na Variant" },
            { "nds_NL", "Low Saxon" },
            { "zh_Hans", "Pinasimpleng Chinese" },
            { "zh_Hant", "Tradisyonal na Chinese" },
            { "%%PINYIN", "Pinyin Romanization" },
            { "%%WADEGILE", "Wade-Giles Romanization" },
            { "type.ca.roc", "Kalendaryong Minguo" },
            { "type.co.eor", "Mga Tuntunin ng European na Pagkakasunud-sunod" },
            { "type.hc.h11", "12 Oras na Sistema (0\u201311)" },
            { "type.hc.h12", "12 Oras na Sistema (1\u201312)" },
            { "type.hc.h23", "24 na Oras na Sistema (0\u201323)" },
            { "type.hc.h24", "24 na Oras na Sistema (1\u201324)" },
            { "type.m0.bgn", "US BGN na Transliteration" },
            { "type.nu.ahom", "Ahom na mga Digit" },
            { "type.nu.arab", "Arabic-Indic na Mga Digit" },
            { "type.nu.armn", "Mga Armenian Numeral" },
            { "type.nu.bali", "Balinese na Mga Digit" },
            { "type.nu.beng", "Mga Bengali Digit" },
            { "type.nu.brah", "Brahmi na Mga Digit" },
            { "type.nu.cakm", "Chakma na Mga Digit" },
            { "type.nu.cham", "Cham na Mga Digit" },
            { "type.nu.cyrl", "Cyrillic na Mga Numero" },
            { "type.nu.deva", "Mga Devanagari Digit" },
            { "type.nu.ethi", "Mga Ethiopic Numeral" },
            { "type.nu.geor", "Georgian na Mga Numeral" },
            { "type.nu.gonm", "Masaram Gondi na mga digit" },
            { "type.nu.grek", "Greek na Mga Numeral" },
            { "type.nu.gujr", "Mga Gujarati Digit" },
            { "type.nu.guru", "Mga Gurmukhi Digit" },
            { "type.nu.hans", "Simplified Chinese na Mga Numeral" },
            { "type.nu.hant", "Traditional Chinese na Mga Numeral" },
            { "type.nu.hebr", "Mga Hebrew Numeral" },
            { "type.nu.hmng", "Pahawh Hmong na Mga Digit" },
            { "type.nu.java", "Javanese na Mga Digit" },
            { "type.nu.jpan", "Mga Japanese Numeral" },
            { "type.nu.kali", "Kayah Li na Mga Digit" },
            { "type.nu.khmr", "Mga Khmer na Digit" },
            { "type.nu.knda", "Mga Kannada na Digit" },
            { "type.nu.lana", "Tai Tham Hora na Mga Digit" },
            { "type.nu.laoo", "Mga Lao na Digit" },
            { "type.nu.latn", "Mga Kanluraning Digit" },
            { "type.nu.lepc", "Lepcha Mga Digit" },
            { "type.nu.limb", "Limbu na Mga Digit" },
            { "type.nu.mlym", "Mga Malayalam na Digit" },
            { "type.nu.modi", "Modi na Mga Digit" },
            { "type.nu.mong", "Mongolian Digits" },
            { "type.nu.mroo", "Mro na Mga Digit" },
            { "type.nu.mtei", "Meetei Mayek na Mga Digit" },
            { "type.nu.mymr", "Mga Myanmar na Digit" },
            { "type.nu.nkoo", "N\u2019Ko na Mga Digit" },
            { "type.nu.olck", "Mga Digit ng Ol Chiki" },
            { "type.nu.orya", "Mga Oriya na Digit" },
            { "type.nu.taml", "Tamil na Mga Numeral" },
            { "type.nu.telu", "Mga Telugu na Digit" },
            { "type.nu.thai", "Mga Thai na Digit" },
            { "type.nu.tibt", "Mga Tibetan na Digit" },
            { "type.nu.vaii", "Mga Vai na Digit" },
            { "type.ca.dangi", "Dangi na Kalendaryo" },
            { "type.co.ducet", "Default na Pagkakasunud-sunod ng Ayos ng Unicode" },
            { "type.co.emoji", "Pagkakasunud-sunod ng Pag-uuri ng Emoji" },
            { "type.lb.loose", "Loose na Istilo ng Line Break" },
            { "type.nu.roman", "Mga Roman Numeral" },
            { "type.ca.coptic", "Kalendaryong Coptic" },
            { "type.ca.hebrew", "Hebrew na Kalendaryo" },
            { "type.ca.indian", "Pambansang Kalendaryong Indian" },
            { "type.co.compat", "Nakaraang Pagkakasunud-sunod ng Pag-uuri, para sa compatibility" },
            { "type.co.pinyin", "Pagkakasunud-sunod ng Pag-uuri ng Pinyin" },
            { "type.co.search", "Pangkalahatang Paghahanap" },
            { "type.co.stroke", "Pagkakasunud-sunod ng Pag-uuri ng Stroke" },
            { "type.co.unihan", "Pagkakasunud-sunod ng Pag-uuri ng Radical-Stroke" },
            { "type.co.zhuyin", "Zhuyin na Pagkakasunud-sunod ng Pag-uuri" },
            { "type.d0.fwidth", "Hanggang sa Fullwidth" },
            { "type.d0.hwidth", "Hanggang sa Halfwidth" },
            { "type.lb.normal", "Normal na Istilo ng Line Break" },
            { "type.lb.strict", "Mahigpit na Istilo ng Line Break" },
            { "type.m0.ungegn", "UN GEGN na Transliteration" },
            { "type.ms.metric", "Metrikong Sistema" },
            { "type.nu.native", "Mga Native na Digit" },
            { "type.ca.chinese", "Kalendaryong Chinese" },
            { "type.ca.islamic", "Kalendaryong Islamic" },
            { "type.ca.iso8601", "ISO-8601 na Kalendaryo" },
            { "type.ca.persian", "Kalendaryong Persian" },
            { "type.cf.account", "Format ng Pera sa Accounting" },
            { "type.co.big5han", "Pagkakasunod-sunod ng Pag-uuri ng Tradisyunal na Chinese - Big5" },
            { "type.d0.npinyin", "Numeric" },
            { "type.nu.arabext", "Extendend Arabic-Indic na Mga Digit" },
            { "type.nu.armnlow", "Armenian Lowercase Numerals" },
            { "type.nu.finance", "Mga Pampinansyang Numeral" },
            { "type.nu.greklow", "Greek Lowercase na Mga Numeral" },
            { "type.nu.hanidec", "Mga Chinese Decimal na Numeral" },
            { "type.nu.hansfin", "Simplified Chinese na Mga Numeral para sa Pananalapi" },
            { "type.nu.hantfin", "Traditional Chinese na Mga Numeral para sa Pananalapi" },
            { "type.nu.jpanfin", "Mga Japanese Numeral sa Pananalapi" },
            { "type.nu.mathdbl", "Matematikal na Dobleng-Struck na Mga Digit" },
            { "type.nu.tamldec", "Mga Tamil na Digit" },
            { "type.ca.buddhist", "Kalendaryo ng Buddhist" },
            { "type.ca.ethiopic", "Kalendaryo ng Ethiopia" },
            { "type.ca.japanese", "Kalendaryong Japanese" },
            { "type.cf.standard", "Karaniwang Format ng Pera" },
            { "type.co.phonetic", "Phonetic na Ayos ng Pag-uuri-uri" },
            { "type.co.reformed", "Pagkakasunud-sunod ng Pag-uuri ng Na-reform" },
            { "type.co.searchjl", "Maghanap Ayon sa Unang Katinig ng Hangul" },
            { "type.co.standard", "Karaniwang Pagkakasunud-sunod ng Ayos" },
            { "type.ms.uksystem", "Sistemang Imperial na Pagsukat" },
            { "type.ms.ussystem", "Sistema ng Pagsukat sa US" },
            { "type.nu.fullwide", "Mga Full-Width Digit" },
            { "type.nu.lanatham", "Tai Tham Tham na Mga Digit" },
            { "type.nu.mathbold", "Matematikal na Bold na Mga Digit" },
            { "type.nu.mathmono", "Matematikal na Mga Digit na May Isang Puwang" },
            { "type.nu.mathsanb", "Matematikal na Sans-Serif Bold na Mga Digit" },
            { "type.nu.mathsans", "Matematikal na Sans-Serif na Mga Digit" },
            { "type.nu.mymrshan", "Maynmar Shan na Mga Digit" },
            { "type.nu.mymrtlng", "Myanmar Tai Laing na Mga Digit" },
            { "type.nu.romanlow", "Roman Lowercase na Mga Numeral" },
            { "type.ca.gregorian", "Gregorian na Kalendaryo" },
            { "type.co.gb2312han", "Pagkakasunud-sunod ng Pag-uuri ng Pinasimpleng Chinese - GB2312" },
            { "type.co.phonebook", "Pagkakasunud-sunod ng Pag-uuri ng Phonebook" },
            { "type.co.dictionary", "Pagkakasunud-sunod ng Pag-uuri ng Diksyunaryo" },
            { "type.co.traditional", "Tradisyunal na Pagkakasunud-sunod ng Pag-uuri" },
            { "type.nu.traditional", "Mga Tradisyunal na Numeral" },
            { "type.ca.islamic-rgsa", "Kalendaryong Islamiko (Saudi Arabia, sighting)" },
            { "type.ca.islamic-tbla", "Kalendaryong Islamiko (tabular, astronomikal na epoch)" },
            { "type.ca.islamic-civil", "Kalendaryong Islamic-Civil" },
            { "type.ca.islamic-umalqura", "Kalendaryong Islam (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Kalendaryong Ethiopic Amete Alem" },
        };
        return data;
    }
}
