// DO NOT EDIT! This test has been generated by /html/canvas/tools/gentest.py.
// OffscreenCanvas test in a worker:2d.text.measure.text-clusters-split.tentative
// Description:Test that getTextClusters() splits the input correctly into the minimal clusters, keeping emojis together.
// Note:

importScripts("/resources/testharness.js");
importScripts("/html/canvas/resources/canvas-tests.js");

var t = async_test("Test that getTextClusters() splits the input correctly into the minimal clusters, keeping emojis together.");
var t_pass = t.done.bind(t);
var t_fail = t.step_func(function(reason) {
    throw reason;
});
t.step(function() {

  var canvas = new OffscreenCanvas(400, 200);
  var ctx = canvas.getContext('2d');

  function getClusterIndexes(text) {
    const clusters = ctx.measureText(text).getTextClusters();
    const result = [];
    for (let i = 0; i < clusters.length; i++) {
      const end = clusters[i].end;
      if (end === (i + 1 < clusters.length ? clusters[i + 1].start : text.length)) {
        result.push(clusters[i].start);
      } else {
        result.push([clusters[i].start, clusters[i].end]);
      }
    }
    return result;
  }

  function assertClusterIndexes(text, expected) {
    const actual = getClusterIndexes(text);
    assert_array_equals(actual, expected);
  }

  ctx.font = '50px serif';
  const text = 'ABC ☺️❤️';
  ctx.fillText(text, 20, 100);
  assertClusterIndexes(text, [0, 1, 2, 3, 4, 6]);

  // [UAX#29]: https://unicode.org/reports/tr29/
  // [UAX#29] GB9: × (Extend | ZWJ)
  assertClusterIndexes('X\u200DY', [0, 2]);
  // [UAX#29] GB11: \p{Extended_Pictographic} Extend* ZWJ × \p{Extended_Pictographic}
  assertClusterIndexes('\u{1FFFD}\u200D\u{1FFFD}', [0]);
  t.done();
});
done();
