# Flatpak and Flathub

This directory contains material for creating a flatpak package
and optionally uploading it to the [audiveris flathub
repository](https://github.com/flathub/org.audiveris.Audiveris).

This documentation strongly derives from the initial documentation entitled
"Flatpak generation and Flathub submission" and located in the former `dev/flatpak/README.md` file.

The main updates relate to:
- The [new structuring of Audiveris project](../project-structure.md) in four sub-projects
named app, flatpak, schemas, windows-installer.
- The use of Gradle tasks and plugins to replace *ad-hoc* scripts.
- The unique definition of key parameters in a single location

## The flathub submodule

The audiveris git tree now contains a submodule for the flathub code
under `flatpak/flathub`. To initialize this submodule, run
``` sh
$ git submodule init
$ git submodule update
```

By tracking this as a git submodule rather than keeping the code
directly in the audiveris git tree, it is possible to push directly
to the flathub repository when a new version must be created.

The ***target*** contents of the flathub directory are as follows:

* The [flatpak manifest](https://manpages.debian.org/testing/flatpak-builder/flatpak-manifest.5.en.html), 
  `org.audiveris.audiveris.yml`,
* The [appstream meta data](https://freedesktop.org/software/appstream/docs/chap-Metadata.html), 
  `org.audiveris.audiveris.metainfo.xml`,
* A linux XDG desktop file, `org.audiveris.audiveris.desktop`,
* Optionally, a `flathub.json` file with flathub build instructions,
* A list of Java dependencies to download from Maven and other repositories,
  the `dependencies.json` file.

Note: These are ***target*** files in the flatpak/flathub folder,
none of them is intended to be written or modified directly.
Instead, they are generated by Gradle tasks as described in the following sections.

## Information sources

The global Gradle components are defined in these files:
- `gradle-wrapper.properties`: definition of the desired gradle version
- `gradle.properties`: definition of the main variables
- `settings.properties`: definition of project structure

Below are the unique locations, relative to the project root, where the Audiveris key parameters are kept.

| Information | Source file path | Variable | Example Value |
| :---        | :---             | :---     | :---          |
| Audiveris version   | app/build.gradle | project(':app').version | 5.4    |
| Audiveris tag       | app/build.gradle | project(':app').ext.tag | 5.4    |
| Gradle | gradle/wrapper/gradle-wrapper.properties | `distributionUrl` | https\://services.gradle.org/distributions/gradle-8.7-all.zip |
| Gradle Sha | gradle/wrapper/gradle-wrapper.properties | `distributionSha256Sum` | 194717442575a6f96e1c1befa2c30e9a4fc90f701d7aee33eb879b79e7ff05c0 |
| Java version | gradle.properties |  `theMinJavaVersion` | 21 |
| Tesseract langs version  | gradle.properties| `theTessdataTag` | 4.1.0 |
| Chosen Xslt processor | gradle.properties | `theXsltTransformer` | XsltProc |

These informations are maintained for the whole Audiveris project, not only for Flatpak.

Regarding the specific case of a new Flatpak version, here are the potential informations to update:
- app/`build.gradle` for the Audiveris `version` and `tag`.
- `gradle.properties` for `theMinJavaVersion`.
- gradle/wrapper/`gradle-wrapper.properties` may need to be adjusted to support the required Java version.  
If so, we must update both  `distributionUrl` and `distributionSha256Sum` properties.
- flatpak/res/`org.audiveris.audiveris.metainfo.xml` to include the new release description using html tags.

Note: the Audiveris tag, for example `5.4`, is essential for the flatpak builder to retrieve
a precise commit of the Audiveris project.
Fortunately, it is a symbolic value: we can keep the same tag name (like 5.4)
while making the tag point to a more recent commit:

To delete and re-create locally:
```sh
# delete
$ git tag -d my_tag

# (re-)create
$ git tag my_tag
```

To push remotely
```sh
$ git push --force origin my_tag
```

## Building flatpak

The generation of Flatpak components is triggered by this command,
entered from the Audiveris root folder:
``` sh
$ ./gradlew -q :flatpak:buildFlatpak
```

This means to launch the task `buildFlatpak` within the sub-project `flatpak`.
Perhaps `buildFlatpak` should be better named `build`, but for the time being this prevents any unwanted build.

This task does two things:
1. First, the `initFlathub` task is run to populate the flatpak/flathub folder
    1. The `genDependencies` task makes sure that Audiveris Java classes (`:app:classes`) have been compiled
    and then run the `:app:flatpakGradleGenerator` plugin to generate the app/build/`dependencies.json` file
    which is then copied to the flatpak/flathub folder.
    2. The `genManifest` task builds the flatpak/flathub/`org.audiveris.audiveris.yml` manifest by expanding
    the template flatpak/dev/`org.audiveris.audiveris.template.yml` file with the variables
    read in gradle/wrapper/`wrapper.properties` and `gradle.properties`.
    3. The content of the flatpak/`res` folder, that is the files `org.audiveris.audiveris.metainfo.xml` 
    and `org.audiveris.audiveris.desktop`, is copied to the flatpak/flathub folder.
2. Second, and only if the host OS name is "linux", it launches `flatpak-builder` as follows:
``` sh
    commandLine('flatpak-builder', 
        '--force-clean',                        // option to empty the output directory
        'build',                                // relative path to the output directory to write
        'org.audiveris.audiveris.yml')          // relative path to the manifest file to read
```

This building of flatpak would be best run on a Linux environment.

NOTA: To make 'flatpak-builder' work correctly in my VirtualBox/Ubuntu environment,
I had first to allow git to copy repositories locally using the "file" protocol:
``` sh
$ git config --global protocol.file.allow always
```

## Building in parts (still a work in progress...)

The previous section (Building flatpak) describes the most convenient approach,
provided that we can use a Linux environment.

If not, we can split the building in two parts:
- First part, under any OS including Windows, someone can generate
the content of flatpak/flathub folder, commit the submodule and push.  
```sh
# Run just the 'initFlathub' task
# NOTA: The targetOS must be explicitly set if it is different from the hosting OS
$ ./gradlew -q -PtargetOS=linux-x86_64 :flatpak:initFlathub

# Commit and push the content of flatpak/flathub
$ git add flatpak/flathub
$ git commit -m "updated flatpak submodule" -- flatpak/flathub
$ git push
```
- Second part, under Linux, someone else can pull, build and submit to flathub.  
XXX TO BE REVIEWED XXX
```sh
# Retrieve flatpak/flathub content
$ git pull

# Build
$ flatpak-builder --force-clean build org.audiveris.audiveris.yml

# Or these commands to build and run with a local repository 

# To export directly to the local $HOME/testrepo
$ flatpak-builder --force-clean --repo=$HOME/testrepo build org.audiveris.audiveris
$ flatpak remote-add --no-gpg-verify --user testrepo file://$HOME/testrepo

# To list audiveris in the local repo
$ flatpak remote-ls testrepo

# To start audiveris
$ flatpak run org.audiveris.audiveris

# Submit to flathub
$ ???
```