---
layout: default
title: Quick tour
parent: Tutorials
nav_order: 2
---
# Quick tour

This chapter describes a very early tour of Audiveris, featuring the basic workflow that goes from
the _image_ of some sheet of music to the _sound_ of the music it represents.

Other chapters will cover in more details each step of perhaps more complex workflows,
but for the sake of simplicity, let's assume that we already have:

* Audiveris installed,
* The image of some sheet of music of rather good quality,
* Perhaps a music sequencer installed (MuseScore for example).

All we have to do is, in sequence:
1. Launch Audiveris,
2. Load the input image,
3. Transcribe the image as a score,
4. Export the score in MusicXML,
5. Play the exported MusicXML file with MuseScore.

For the impatient, note that if we have defined a [plugin](../../guides/advanced/plugins.md)
to a sequencer like MuseScore, the sub-sequence of bullets \#3, \#4 and \#5 above could
conveniently be replaced by just pressing the plugin button.  
This would now give:
1. Launch Audiveris,
2. Load the input image,
3. Press the Plugin button.
