---
layout: default
title: View menu
parent: Menus
nav_order: 5
---
 View menu
{: .no_toc }

![](../../assets/images/view_menu.png)

---
Table of contents
{: .no_toc .text-epsilon }
1. TOC
{:toc}
---

## Width fit

Zoom image to window width.

## Height fit

Zoom image to window height.

## Display invalid sheets

Toggle the display all sheets, even invalid ones.

## Use transparency

Display interpretations in transparency according to the computed probability value.

## Show jumbo inters (F7)

Toggle the display of certain shapes (dots by default) with a double size
to ease their visual checking.

## Show score voices (F8)

Toggle the display of notes and lyrics in colors according to the computed voices
(only in output and mixed layer view).

## Show score errors (F9)

Toggle the display of erroneous measures in pink background color.

## Switch selections (F11)

Toggles the selection modes between glyph, inter and section.

(needs the ``SPECIFIC_VIEWS`` advanced topic)

## Switch layers (F12)

Toggle between the 3 different layer views (see [Sheet display modes](../../tutorials/main_window/display_modes.md)).

## Show score slots

Display the detected rhythm analysis (only in output and mixed view).

## Show annotations

Toggle the display of all system, part, measure and rhythm related annotations
(system ID, part name, measure ID, time slot offset).

## Show chord IDs

Toggle the display of every chord ID.

This is convenient to visually map chords between [measure strips](./popup.md#measure-n)
and sheet view.

## Show part names

Toggle the display of logical part name for every physical part.

## Show staff lines

Toggle the display of staff lines.

(needs the ``SPECIFIC_ITEMS`` advanced topic)

## Show staff points

Toggle the display of staff lines defining points, the ones that can be manually edited.

(needs the ``SPECIFIC_ITEMS`` advanced topic)


## Show stick lines

Toggle the display of the average line of the selected glyph.

(needs the ``SPECIFIC_ITEMS`` advanced topic)

## Show attachments

Toggle the display of specific attachments.

These attachments are drawings related to the processing of some entities
(such as arc lookup areas to connect candidate slur portions).
They are helpful only for visual checking of specific steps and thus are not persisted on disk.

(needs the ``SPECIFIC_ITEMS`` advanced topic)
