---
layout: default
title: Shape board
parent: Boards
nav_order: 7
---
# Shape board
{: .no_toc :}

This board allows to handle about 200 different shapes.  
To this end, the shapes are organized into some 20 shape-sets,
and each shape-set is presented in a dedicated palette.

---
Table of contents
{: .no_toc .text-epsilon }
1. TOC
{:toc}
---

## Catalog of all shape-sets

![](../../assets/images/shape_board.png)

The shape board initially displays the catalog of all shape-sets.

In the picture above, we can see:
- Accidentals, Articulations, Attributes, Barlines, BeamsAndTuplets,
  Clefs, Dynamics, Flags, Holds,
- Keys, HeadsAndDot, Markers, Ornaments, Rests, Times, Digits,
  Pluckings, Romans,
- Texts, Physicals.

From this catalog, displayed with a dark background, no action like a drag n' drop can be launched.
The purpose of the catalog is only to choose a shape-set.

## One shape-set palette

Clicking on a shape-set button replaces the global catalog by the selected shape-set,
presented in a dedicated palette.  
For example, clicking on the ``HeadsAndDot`` button will display the ``HeadsAndDot`` palette,
whose content adapts to the book at hand:

Here is a simple configuration

![](../../assets/images/HeadsAndDot_palette.png)

And here is a more complex configuration for drums notation.   
See the [Drums](../../guides/specific/drums.md) chapter for further details.

![](../../assets/images/font_ophelia_heads.png)

From any shape palette we can:
* Assign a shape to the current glyph, via a double-click on the proper shape button;
* Initiate a drag & drop action, by pressing the proper shape button and dragging it
to the desired location in sheet.

To leave the current palette and return to the global shape-set catalog,
we press the `ESCAPE` key or click on the ``up`` (&#x25B2;) button.

## Recently used shapes
The shapes most recently used (by whatever means) always appear at the top of the shape board,
making them easily available for a direct reuse.

![](../../assets/images/shape_cache.png)

## Palettes contents

| Palette name      | Palette content |
| :---              | :---       |
| Accidentals       | ![](../../assets/images/Accidentals_palette.png) |
| Articulations     | ![](../../assets/images/Articulations_palette.png) |
| Attributes        | ![](../../assets/images/Attributes_palette.png) |
| Barlines          | ![](../../assets/images/Barlines_palette.png) |
| BeamsEtc          | ![](../../assets/images/BeamsEtc_palette.png) |
| ClefsAndShifts    | ![](../../assets/images/ClefsAndShifts_palette.png) |
| Dynamics          | ![](../../assets/images/Dynamics_palette.png) |
| Flags             | ![](../../assets/images/Flags_palette.png) |
| Holds             | ![](../../assets/images/Holds_palette.png) |
| Keys              | ![](../../assets/images/Keys_palette.png) |
| HeadsAndDot       | ![](../../assets/images/HeadsAndDot_palette.png) |
| Markers           | ![](../../assets/images/Markers_palette.png) |
| GraceAndOrnaments | ![](../../assets/images/GraceAndOrnaments_palette.png) |
| Rests             | ![](../../assets/images/Rests_palette.png) |
| Times             | ![](../../assets/images/Times_palette.png) |
| Digits            | ![](../../assets/images/Digits_palette.png) |
| Pluckings         | ![](../../assets/images/Pluckings_palette.png) |
| Romans            | ![](../../assets/images/Romans_palette.png) |
| Texts             | ![](../../assets/images/Texts_palette.png) |
| Physicals         | ![](../../assets/images/Physicals_palette.png) |
