//------------------------------------------------------------------------------------------------//
//                                                                                                //
//                             I n j e c t i o n S o l v e r T e s t                              //
//                                                                                                //
//------------------------------------------------------------------------------------------------//
// <editor-fold defaultstate="collapsed" desc="hdr">
//
//  Copyright © Audiveris 2025. All rights reserved.
//
//  This program is free software: you can redistribute it and/or modify it under the terms of the
//  GNU Affero General Public License as published by the Free Software Foundation, either version
//  3 of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU Affero General Public License for more details.
//
//  You should have received a copy of the GNU Affero General Public License along with this
//  program.  If not, see <http://www.gnu.org/licenses/>.
//------------------------------------------------------------------------------------------------//
// </editor-fold>
package org.audiveris.omr.math;

import org.audiveris.omr.util.WrappedInteger;

import org.junit.Ignore;

import junit.framework.*;

/**
 * @author Hervé Bitteur
 */
public class InjectionSolverTest
        extends TestCase
{
    /**
     * Creates a new InjectionSolverTest object.
     *
     * @param testName DOCUMENT ME!
     */
    public InjectionSolverTest (String testName)
    {
        super(testName);
    }

    /**
     * Test of solve method, of class omr.math.InjectionSolver.
     */
    public void testSolve ()
    {
        System.out.println("solve");

        InjectionSolver instance = new InjectionSolver(3, 3, new MyDistance());

        final WrappedInteger bestCost = new WrappedInteger(null);
        int[] expResult = new int[] { 0, 1, 2 };
        int[] result = instance.solve(bestCost);

        assertTrue(result.length == expResult.length);
        for (int i = 0; i < expResult.length; i++) {
            assertTrue(result[i] == expResult[i]);
        }
    }

    protected void setUp ()
        throws Exception
    {
    }

    protected void tearDown ()
        throws Exception
    {
    }

    @Ignore
    public static class MyDistance
            implements InjectionSolver.Distance
    {
        public MyDistance ()
        {
        }

        @Override
        public int getDistance (int in,
                                int ip,
                                StringBuilder details)
        {
            return Math.abs((1 + in) - ip);
        }
    }
}
